<?php

namespace App\Http\Requests;

use App\Facades\Settings;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Http\FormRequest;
use Mtc\MercuryDataModels\Vehicle;

class SalesForceVehicleNotificationRequest extends FormRequest
{
    protected ?Model $vehicle;

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Settings::get('sales-force-inbound-vehicle-notifications-enabled')
            && !empty(Settings::get('sales-force-inbound-vehicle-notifications-bearer-token'))
            && $this->header('Authorization') === 'Bearer '
            . Settings::get('sales-force-inbound-vehicle-notifications-bearer-token');
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'vehicle_id' => [
                'required',
            ],
            'price' => [
                'required',
                'numeric',
            ],
            'is_published' => [
                'required',
                'boolean',
            ],
            'is_reserved' => [
                'required',
                'boolean',
            ],
            'is_sold' => [
                'required',
                'boolean',
            ],
        ];
    }

    /**
     * Get the vehicle record
     *
     * @return Vehicle|Model|null
     */
    public function vehicle(): ?Vehicle
    {
        if (!isset($this->vehicle)) {
            $this->vehicle = Vehicle::query()
                ->where('uuid', $this->input('vehicle_id'))
                ->first();
        }

        return $this->vehicle;
    }
}
