<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class ProxyValuationRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return base64_decode($this->header('authorization')) === tenant('id') . ':' . config('app.proxy_token');
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'registration_number' => [
                'required',
            ],
            'mileage' => [
                'required' => 'numeric',
            ]
        ];
    }
}
