<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;

class BulkUpdateSeoDefaultRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'defaults.*.id' => [
                'required',
                'numeric',
                'exists:seo_defaults,id'
            ],
            'defaults.*.title' => [
                'required',
                'max:250',
            ],
            'defaults.*.description' => [
                'present',
                'max:250',
            ],
        ];
    }

    public function attributes()
    {
        Log::debug('bulk update default values', collect($this->input('defaults'))
            ->flatMap(fn ($input, $index) => [
                "defaults.$index.title" => $input['section'] . ' title',
                "defaults.$index.description" => $input['section'] . ' description',
                "defaults.$index.og_image" => $input['section'] . ' og_image',
            ])
            ->toArray());
        return collect($this->input('defaults'))
            ->flatMap(fn ($input, $index) => [
                "defaults.$index.title" => $input['section'] . ' title',
                "defaults.$index.description" => $input['section'] . ' description',
                "defaults.$index.og_image" => $input['section'] . ' OG image',
            ])
            ->toArray();
    }
}
