<?php

namespace App\Http\Middleware;

use App\Tier;
use App\TierHelper;
use Closure;
use Illuminate\Http\Request;

class TierMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next, string $minimal_tier)
    {
        if (TierHelper::isAllowed(tenant()->tier, $minimal_tier)) {
            return $next($request);
        }

        return abort(401);
    }
}
