<?php

namespace App\Http\Middleware;

use App\Facades\Feature;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class EnabledFeatureMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next, string $featureName): Response
    {
        if (Feature::isEnabled($featureName)) {
            return $next($request);
        }
        return \response('Access denied', 401);
    }
}
