<?php

namespace App\Http\Controllers;

use Illuminate\Http\Response;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Storage;

class SitemapController extends Controller
{
    public function status(): array
    {
        $path = tenant('id') . '/sitemap.xml';
        $exists = Storage::disk('file-storage')->exists($path);

        return [
            'exists' => $exists,
            'last_modified' => $exists ? Storage::disk('file-storage')->lastModified($path) : null,
            'url' => $exists ? Storage::disk('file-storage')->url($path) : null,
        ];
    }

    public function generate(): Response
    {
        Artisan::call('make:sitemap');

        return response(['success' => true, 'message' => 'Sitemap generated successfully']);
    }
}
