<?php

namespace App\Http\Controllers;

use App\Exports\Seo404Export;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Maatwebsite\Excel\Facades\Excel;
use Mtc\MercuryDataModels\Seo404;
use Symfony\Component\HttpFoundation\BinaryFileResponse;

class Seo404Controller extends Controller
{
    public function __construct()
    {
        $this->middleware([
            'permission:edit-seo',
        ]);
    }

    /**
     * List Seo Data entries
     *
     * @return \Illuminate\Contracts\Pagination\LengthAwarePaginator
     */
    public function index(Request $request)
    {
        return Seo404::query()
            ->when(
                $request->filled('search_term'),
                fn($query) => $query->where('path', 'like', "%" . $request->input('search_term') . "%")
            )
            ->latest()
            ->paginate()
            ->toArray();
    }

    /**
     * Export seo data to excel file
     *
     * @return BinaryFileResponse
     */
    public function export()
    {
        return Excel::download(new Seo404Export(), Str::slug(tenant('name')) . 'seo_404s.xlsx');
    }
}
