<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreReservationStatusRequest;
use App\Http\Requests\UpdateReservationStatusRequest;
use App\Http\Resources\ReservationStatusList;
use App\Http\Resources\ReservationStatusView;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Mtc\VehicleReservations\ReservationStatus;

class ReservationStatusController
{
    use ValidatesRequests;

    public function index(): ReservationStatusList
    {
        return new ReservationStatusList(ReservationStatus::query()->paginate());
    }

    public function store(StoreReservationStatusRequest $request): ReservationStatusView
    {
        $reservationStatus = ReservationStatus::query()
            ->create($request->input());
        return new ReservationStatusView($reservationStatus);
    }

    public function show(ReservationStatus $reservationStatus): ReservationStatusView
    {
        return new ReservationStatusView($reservationStatus);
    }

    public function update(UpdateReservationStatusRequest $request, ReservationStatus $category)
    {
        $category->update($request->input());
        $category->refresh();

        return [
            'category' => $category,
            'success' => true,
        ];
    }

    public function destroy(ReservationStatus $reservationStatus)
    {
        return $reservationStatus->delete();
    }
}
