<?php

namespace App\Http\Controllers;

use App\OptionListRepository;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class OptionListController extends Controller
{
    public function index(Request $request, string $type, OptionListRepository $repository)
    {
        return $repository->getForType($type, $request);
    }

    public function getDealershipEmailFields(OptionListRepository $repository)
    {
        return $repository->getDealershipEmailFields();
    }

    public function getTypes(): Response
    {
        return \response([
            [
                'value' => 'static-list',
                'name' => 'Manually entered list'
            ],
            [
                'value' => 'api-endpoint',
                'name' => 'API endpoint'
            ],
            [
                'value' => 'primitives',
                'name' => 'Content Primitives'
            ],
            [
                'value' => 'dealerships',
                'name' => 'Dealerships'
            ],
            [
                'value' => 'franchises',
                'name' => 'Franchises'
            ],
            [
                'value' => 'makes',
                'name' => 'Makes'
            ],
            [
                'value' => 'fuel-types',
                'name' => 'Fuel Types'
            ],
            [
                'value' => 'body-styles',
                'name' => 'Body Styles'
            ],
            [
                'value' => 'pages',
                'name' => 'Pages'
            ],
            [
                'value' => 'menus',
                'name' => 'Menus'
            ],
            [
                'value' => 'templates',
                'name' => 'Templates'
            ],
            [
                'value' => 'elements',
                'name' => 'Elements'
            ],
            [
                'value' => 'global-content',
                'name' => 'Global Content'
            ],
            [
                'value' => 'forms',
                'name' => 'Forms'
            ],
            [
                'value' => 'blog-pages',
                'name' => 'Blog Pages'
            ],
            [
                'value' => 'news-pages',
                'name' => 'News Pages'
            ],
            [
                'value' => 'offers',
                'name' => 'Offers'
            ],
            [
                'value' => 'vehicles',
                'name' => 'Vehicles'
            ],
            [
                'value' => 'taxonomies',
                'name' => 'Taxonomies'
            ],
            [
                'value' => 'labels',
                'name' => 'Labels'
            ],
            [
                'value' => 'catalog-offers',
                'name' => 'Catalog Offers'
            ],
        ]);
    }

    private function getIndexType(string $type): string
    {
        return match ($type) {
            'makes' => 'make',
            'fuel-types' => 'fuel_type',
            'body-styles' => 'body_type',
        };
    }
}
