<?php

namespace App\Http\Controllers;

use App\VehicleType;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Http\Request;
use Mtc\MercuryDataModels\VehicleMake;

class MakeController extends Controller
{
    /**
     * Display a listing of vehicle makes
     *
     * @return LengthAwarePaginator|array
     */
    public function index(Request $request)
    {
        $typeColumn = $this->getTypeColumn($request->input('type'));

        $query = VehicleMake::query()
            ->with('filterIndex')
            ->when($request->has('with-models'), fn ($query) => $query->with('models'))
            ->when($typeColumn, fn ($query) => $query->where($typeColumn, 1))
            ->orderBy('name');

        if ($request->has('all')) {
            return ['data' => $query->select('name', 'id')->get()];
        }

        return $query->paginate();
    }

    /**
     * Display the specified vehicle make.
     *
     * @param  VehicleMake $make
     * @return VehicleMake
     */
    public function show(VehicleMake $make)
    {
        return $make;
    }

    private function getTypeColumn(?string $type): ?string
    {
        return match ($type) {
            VehicleType::CAR->value => 'cars',
            VehicleType::LCV->value => 'lcvs',
            VehicleType::MOTORCYCLE->value => 'motorcycles',
            default => null,
        };
    }
}
