<?php

namespace App\Http\Controllers;

use App\Http\Requests\LeaseImportBulkUpdateModelRequest;
use Illuminate\Http\Request;
use Mtc\MercuryDataModels\VehicleModel;

class LeaseImportModelController extends Controller
{
    public function index(Request $request, $make_id)
    {
        $perPage = min((int) $request->input('per_page', 15), 9999);

        return VehicleModel::query()
            ->where('make_id', $make_id)
            ->setSortBy($request->input('sort_by', 'name'))
            ->paginate($perPage);
    }

    public function updateBulk(LeaseImportBulkUpdateModelRequest $request)
    {
        collect($request->input('models') ?? [])->each(function ($model) {
            VehicleModel::query()
                ->where('id', $model['id'])
                ->update([
                    'keyloop_import_enabled' => $model['keyloop_import_enabled'],
                ]);
        });
    }
}
