<?php

namespace App\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Mtc\Crm\Facades\Enquiries;

class EnquiryController extends Controller
{
    /**
     * Mark enquiries as spam - sets status to Spam and soft-deletes
     *
     * @param Request $request
     * @return JsonResponse
     */
    public function markAsSpam(Request $request): JsonResponse
    {
        $request->validate([
            'ids' => 'required|array',
            'ids.*' => 'integer|exists:enquiries,id',
        ]);

        $count = Enquiries::markAsSpam($request->input('ids'));

        return response()->json([
            'status' => 'ok',
            'message' => $count === 1
                ? '1 enquiry marked as spam'
                : "{$count} enquiries marked as spam",
            'count' => $count,
        ]);
    }
}
