<?php

namespace App\Http\Controllers;

use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Mtc\MercuryDataModels\DrivetrainType;

class DrivetrainController extends Controller
{
    /**
     * Display a listing of drivetrains
     *
     * @return LengthAwarePaginator
     */
    public function index()
    {
        return DrivetrainType::query()->orderBy('name')->paginate();
    }

    /**
     * Display the specified drivetrain.
     *
     * @param  DrivetrainType $drivetrain
     * @return DrivetrainType
     */
    public function show(DrivetrainType $drivetrain)
    {
        return $drivetrain;
    }
}
