<?php

namespace App\Http\Controllers;

use App\CarConfiguratorRepository;
use App\Http\Resources\ConfiguratorPackageList;
use App\Http\Resources\ConfiguratorPackageView;
use Illuminate\Http\Request;
use Mtc\ContentManager\Facades\Media;
use Mtc\MercuryDataModels\CarConfiguratorPackage;

class ConfiguratorPackageController extends Controller
{
    public function index(Request $request): ConfiguratorPackageList
    {
        return new ConfiguratorPackageList(CarConfiguratorPackage::query()->paginate());
    }

    public function store(Request $request): ConfiguratorPackageView
    {
        $package = CarConfiguratorPackage::query()->create([
            'name' => $request->input('name')
        ]);
        return new ConfiguratorPackageView($package);
    }

    public function show(CarConfiguratorPackage $carConfiguratorPackage): ConfiguratorPackageView
    {
        return new ConfiguratorPackageView($carConfiguratorPackage);
    }

    public function update(Request $request, CarConfiguratorPackage $carConfiguratorPackage): ConfiguratorPackageView
    {
        $carConfiguratorPackage->update($request->input());
        Media::setUsesForModel($request->input('media', []), $carConfiguratorPackage);
        return new ConfiguratorPackageView($carConfiguratorPackage);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Request $request, CarConfiguratorPackage $carConfiguratorPackage): ConfiguratorPackageList
    {
        $carConfiguratorPackage->delete();
        return $this->index($request);
    }
}
