<?php

namespace App\Http\Controllers;

use App\Http\Resources\ConfiguratorExtraList;
use App\Http\Resources\ConfiguratorExtraView;
use Illuminate\Http\Request;
use Mtc\ContentManager\Facades\Media;
use Mtc\MercuryDataModels\CarConfiguratorExtra;

class ConfiguratorExtraController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request): ConfiguratorExtraList
    {
        return new ConfiguratorExtraList(CarConfiguratorExtra::query()->paginate());
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request): ConfiguratorExtraView
    {
        $extra = CarConfiguratorExtra::query()->create([
            'name' => $request->input('name')
        ]);
        return new ConfiguratorExtraView($extra);
    }

    /**
     * Display the specified resource.
     */
    public function show(CarConfiguratorExtra $carConfiguratorExtra): ConfiguratorExtraView
    {
        return new ConfiguratorExtraView($carConfiguratorExtra);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, CarConfiguratorExtra $carConfiguratorExtra): ConfiguratorExtraView
    {
        $carConfiguratorExtra->update($request->input());
        Media::setUsesForModel($request->input('media', []), $carConfiguratorExtra);
        return new ConfiguratorExtraView($carConfiguratorExtra);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Request $request, CarConfiguratorExtra $carConfiguratorExtra): ConfiguratorExtraList
    {
        $carConfiguratorExtra->delete();
        return $this->index($request);
    }
}
