<?php

namespace App\Facades;

use App\Modules\VehicleLabels\LabelRepository;
use Illuminate\Support\Facades\Facade;
use Mtc\MercuryDataModels\Label;
use Mtc\MercuryDataModels\Vehicle;

/**
 * @method static array getAutomationOptions()
 * @method static array getVehicleTypeOptions()
 * @method static bool shouldAssign(Vehicle $vehicle, Label $label)
 * @method static bool shouldRevoke(Vehicle $vehicle, Label $label)
 * @see LabelRepository
 */
class Labels extends Facade
{
    /**
     * Define the facade accessor
     *
     * @return string
     */
    protected static function getFacadeAccessor()
    {
        return 'label-repository';
    }
}
