<?php

namespace App\Facades;

use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Facade;
use Mtc\MercuryDataModels\Repositories\FeatureRepository;
use Mtc\MercuryDataModels\Tenant;

/**
 * @method static bool isEnabled(string $feature)
 * @method static Collection getAll()
 * @method static Collection enabledForTenant()
 * @method static void setEnabled(Tenant $tenant, array $features)
 * @see FeatureRepository
 */
class Feature extends Facade
{
    /**
     * Define the facade accessor
     *
     * @return string
     */
    protected static function getFacadeAccessor()
    {
        return 'feature-flags';
    }
}
