<?php

namespace App\Exports;

use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithStrictNullComparison as NullComparison;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class EnquiriesByTypeExport implements FromCollection, WithHeadings, ShouldAutoSize, NullComparison, WithStyles
{
    public function __construct(protected Collection $data)
    {
        //
    }

    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        return $this->data;
    }

    /**
     * Heading row
     *
     * @return string[]
     */
    public function headings(): array
    {
        return [
            __('labels.type'),
            __('labels.total'),
        ];
    }

    public function styles(Worksheet $sheet)
    {
        $last_row = $this->data->count() + 1;
        $sheet->getStyle('A1:B1')->getFont()->setBold(true);
        $sheet->getStyle('A1:A' . $last_row)->getFont()->setBold(true);
        $sheet->setSelectedCell('A1');
    }
}
