<?php

namespace App\Exports;

use App\Facades\Settings;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Mtc\MercuryDataModels\Dealership;

class AaCarsDealerExport implements FromCollection, WithHeadings
{
    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        return Dealership::query()
            ->has('vehicles')
            ->get()
            ->map(function (Dealership $dealership) {
                return [
                    'feed_id' => $dealership->data['aa-cars-dealer-id'] ?? null,
                    'dealername' => $dealership->name,
                    'address' => $dealership->address1 . ' ' . $dealership->address2 . ' ' . $dealership->city,
                    'postcode' => $dealership->postcode,
                    'phone_number' => $dealership->contact_no,
                    'email' => $dealership->email,
                ];
            });
    }

    /**
     * Heading row
     *
     * @return string[]
     */
    public function headings(): array
    {
        return [
            'feed_id',
            'dealername',
            'address',
            'postcode',
            'phone_number',
            'email',
        ];
    }
}
