<?php

namespace App\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;
use Mtc\MercuryDataModels\Vehicle;
use Illuminate\Contracts\Events\ShouldDispatchAfterCommit;

class VehicleUpdatedFromImport implements ShouldDispatchAfterCommit
{
    use Dispatchable;
    use InteractsWithSockets;
    use SerializesModels;

    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct(
        public readonly Vehicle $vehicle,
        public readonly array $payload = [],
        public readonly string $provider = ''
    ) {
        //
    }
}
