<?php

namespace App\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;
use Mtc\MercuryDataModels\Vehicle;

class VehiclePriceChangedDuringStockSync
{
    use Dispatchable;
    use InteractsWithSockets;
    use SerializesModels;

    /**
     * Create a new event instance.
     */
    public function __construct(private readonly Vehicle $vehicle, private readonly string $provider)
    {
        //
    }

    public function getVehicle(): Vehicle
    {
        return $this->vehicle;
    }

    public function getProvider(): string
    {
        return $this->provider;
    }
}
