<?php

namespace App;

use App\Contracts\InteractsWithContentSync;
use Mtc\ContentManager\Models\ContentCategory;

class ContentCategoryRepository implements InteractsWithContentSync
{
    public function importRecord(array $entry): bool
    {
        $contentCategory = ContentCategory::query()->create($entry);

        return $contentCategory->exists;
    }

    public function canBeImported(array $entry): bool
    {
        return !ContentCategory::query()
            ->where('slug', $entry['slug'])
            ->exists();
    }

    public function exportToRemote(array $selections): array
    {
        return ContentCategory::query()
            ->select([
                'name',
                'slug',
            ])
            ->whereIn('id', $selections)
            ->get()
            ->toArray();
    }

    public function checkImportEntryValidity(array $dataEntry, array $allEntries): array
    {
        $errors = [];

        if (empty($dataEntry['slug'])) {
            $errors[] = __('validation.import_slug_missing', ['slug' => $dataEntry['slug']]);
        } elseif (ContentCategory::query()->where('slug', $dataEntry['slug'])->exists()) {
            $errors[] = __('validation.import_slug_taken', ['slug' => $dataEntry['slug']]);
        }

        return [
            'data' => $dataEntry,
            'errors' => $errors,
        ];
    }
}
