<?php

namespace App\Console\Commands;

use App\Facades\Settings;
use App\VehicleSpec\Jobs\FetchVehicleSpecData;
use App\VehicleSpec\Jobs\VehicleCapIdLookup;
use App\VehicleSpec\VehicleSpecServiceHelper;
use Illuminate\Console\Command;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Mtc\MercuryDataModels\Vehicle;

class UpdateVehiclesSpecData extends Command
{
    use DispatchesJobs;

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'vehicles-spec:update-data';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Update Vehicles Spec Data';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $vehicles = Vehicle::all();
        foreach ($vehicles as $vehicle) {
            if (VehicleSpecServiceHelper::canRunForVehicle($vehicle)) {
                $this->dispatch(new FetchVehicleSpecData($vehicle));
            }
        }
    }
}
