<?php

namespace App\Console\Commands;

use App\Facades\Settings;
use App\VehicleSpec\Jobs\VehicleCapIdLookup;
use Illuminate\Console\Command;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Mtc\MercuryDataModels\Vehicle;

class UpdateCapData extends Command
{
    use DispatchesJobs;

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'cap:update-data';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Update Vehicle Data From Cap';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        if (Settings::get('vehicle-spec-providers-cap-enabled')) {
            $vehicles = Vehicle::all();
            foreach ($vehicles as $vehicle) {
                $this->dispatch(new VehicleCapIdLookup($vehicle, true));
            }
        }
    }
}
