<?php

namespace App\Console\Commands;

use App\Master\Models\BodyStyleType;
use App\Master\Models\DrivetrainType;
use App\Master\Models\FuelType;
use App\Master\Models\TransmissionType;
use App\Master\Models\VehicleMake;
use App\Master\Models\VehicleModel;
use Illuminate\Console\Command;
use Mtc\MercuryDataModels\VehicleMake as TenantVehicleMake;
use Mtc\MercuryDataModels\VehicleModel as TenantVehicleModel;
use Mtc\MercuryDataModels\DrivetrainType as TenantDrivetrainType;
use Mtc\MercuryDataModels\FuelType as TenantFuelType;
use Mtc\MercuryDataModels\BodyStyleType as TenantBodyStyleType;
use Mtc\MercuryDataModels\TransmissionType as TenantTransmissionType;
use Stancl\Tenancy\Concerns\HasATenantsOption;

class TenantsSyncTaxonomies extends Command
{
    use HasATenantsOption;

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'tenants:sync-taxonomies';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Sync taxonomies from master to tenants';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        tenancy()->runForMultiple($this->option('tenants'), function ($tenant) {
            $this->line("Tenant: {$tenant->getTenantKey()}");

            VehicleMake::all()
                ->each(fn($data) => TenantVehicleMake::query()->updateOrCreate([
                    'id' => $data->id,
                ], [
                    'slug' => $data->slug,
                    'name' => $data->name,
                    'autotrader_id' => $data->autotrader_id,
                    'cap_id' => $data->cap_id,
                    'lcv_cap_id' => $data->lcv_cap_id,
                    'logo' => $data->logo,
                    'monochrome_logo' => $data->monochrome_logo,
                    'primary_colour' => $data->primary_colour,
                    'secondary_colour' => $data->secondary_colour,
                    'keyloop_id' => $data->keyloop_id,
                    'cars' => $data->cars,
                    'lcvs' => $data->lcvs,
                    'motorcycles' => $data->motorcycles,
                    'caravans' => $data->caravans,
                    'motorhomes' => $data->motorhomes,
                ]));

            VehicleModel::all()
                ->each(fn($model) => TenantVehicleModel::query()->updateOrCreate([
                    'id' => $model->id,
                ], [
                    'slug' => $model->slug,
                    'autotrader_id' => $model->autotrader_id,
                    'name' => $model->name,
                    'make_id' => $model->make_id,
                    'cap_id' => $model->cap_id,
                    'lcv_cap_id' => $model->lcv_cap_id,
                    'type' => $model->type,
                    'keyloop_id' => $model->keyloop_id,
                ]));

            BodyStyleType::all()
                ->each(fn($data) => TenantBodyStyleType::query()->updateOrCreate(
                    ['id' => $data->id],
                    [
                        'id' => $data->id,
                        'slug' => $data->slug,
                        'name' => $data->name,
                        'type' => $data->type,
                    ]
                ));

            DrivetrainType::all()
                ->each(fn($data) => TenantDrivetrainType::query()->updateOrCreate(
                    ['id' => $data->id],
                    [
                        'id' => $data->id,
                        'slug' => $data->slug,
                        'name' => $data->name,
                    ]
                ));

            FuelType::all()
                ->each(fn($data) => TenantFuelType::query()->updateOrCreate(
                    ['id' => $data->id],
                    [
                        'id' => $data->id,
                        'slug' => $data->slug,
                        'name' => $data->name,
                    ]
                ));

            TransmissionType::all()
                ->each(fn($data) => TenantTransmissionType::query()->updateOrCreate(
                    ['id' => $data->id],
                    [
                        'id' => $data->id,
                        'slug' => $data->slug,
                        'name' => $data->name,
                    ]
                ));
        });
        return 0;
    }
}
