<?php

namespace App\Console\Commands;

use Database\Seeders\ThemeContentSeeder;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Hash;
use Mtc\MercuryDataModels\Role;
use Mtc\MercuryDataModels\User;

class SeedAdminUser extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'seed:admin-user';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Seed admin user (non-mtc)';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $email = $this->ask('Email:');
        $password = $this->ask('Password: ');

        /** @var User $user */
        $user = User::query()
            ->create([
                'name' => '',
                'email' => $email,
                'password' => Hash::make($password)
            ]);

        $role = Role::query()->where('name', config('mtc_login.mtc_user_role'))->first();
        $user->roles()->attach($role->id);
        return 0;
    }
}
