<?php

namespace App\Console\Commands;

use App\Facades\Settings;
use Illuminate\Console\Command;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Mtc\MercuryDataModels\Finance\Contracts\BatchRequestsQuotes;
use Mtc\MercuryDataModels\Finance\FinanceServiceHelper;
use Mtc\MercuryDataModels\Finance\Jobs\RunQuoteRequest;

class RequestQuotes extends Command
{
    use DispatchesJobs;

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'finance:request-quotes';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Request quotes from finance provider';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        if (!FinanceServiceHelper::hasEnabledProvider()) {
            return Command::SUCCESS;
        }

        $provider = FinanceServiceHelper::initializeForSite();
        if ($provider instanceof BatchRequestsQuotes && Settings::get('finance-batch-update')) {
            $this->output->info('Requesting quotes for ' . tenant('id'));
            $this->dispatch(new RunQuoteRequest($provider, !app()->runningInConsole()));
        }

        return Command::SUCCESS;
    }
}
