<?php

namespace App\Console\Commands;

use App\Master\Models\VehicleModel;
use Illuminate\Console\Command;
use Mtc\MercuryDataModels\VehicleModel as TenantModel;

class RemoveModelsWithoutMakes extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'clean:vehicle-models';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Remove vehicle makes without models';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        VehicleModel::query()
            ->whereDoesntHave('make')
            ->delete();

        tenancy()->runForMultiple(null, fn() => TenantModel::query()->whereDoesntHave('make')->delete());
        return Command::SUCCESS;
    }
}
