<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Mtc\Crm\Traits\RetrievesCustomerId;
use Mtc\MercuryDataModels\Booking;
use Mtc\MercuryDataModels\Enquiry;
use Mtc\VehicleReservations\Reservation;

class LinkAndCreateCustomerAccounts extends Command
{
    use RetrievesCustomerId;

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'customers:link-and-create';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Link & create customer accounts for records missing details';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->enquiries();
        $this->bookings();
        $this->reservation();
        return self::SUCCESS;
    }

    private function enquiries()
    {
        Enquiry::query()
            ->whereNotNull('ingested_at')
            ->whereNull('customer_id')
            ->get()
            ->filter(fn($enquiry) => !empty($enquiry->email))
            ->each(fn ($enquiry) => $enquiry->update([
                'customer_id' => $this->getCustomerId($enquiry->email, $this->getEnquiryDetails($enquiry))
            ]));
    }

    private function bookings()
    {
        Booking::query()
            ->whereNotNull('ingested_at')
            ->whereNull('customer_id')
            ->get()
            ->filter(fn($booking) => !empty($booking->email))
            ->each(fn ($booking) => $booking->update([
                'customer_id' => $this->getCustomerId($booking->email, $this->getBookingDetails($booking))
            ]));
    }

    private function reservation()
    {
        Reservation::query()
            ->whereNotNull('ingested_at')
            ->whereNull('customer_id')
            ->get()
            ->filter(fn($reservation) => !empty($reservation->email))
            ->each(fn ($reservation) =>$reservation->update([
                'customer_id' => $this->getCustomerId($reservation->email, $this->getReservationDetail($reservation))
            ]));
    }

    private function getEnquiryDetails($enquiry): array
    {
        $details = [];
        foreach ($enquiry->details as $answer) {
            $is_phone_number = stripos($answer['question'], 'contact number') !== false
                || stripos($answer['question'], 'contact no') !== false
                || stripos($answer['question'], 'phone number') !== false;
            if ($is_phone_number) {
                $details['phone_number'] = $answer['answer'];
            }

            $is_first_name = stripos($answer['question'], 'first name') !== false
                || stripos($answer['question'], 'firstname') !== false;
            if ($is_first_name) {
                $details['first_name'] = $answer['answer'];
            }

            $is_last_name = stripos($answer['question'], 'last name') !== false
                || stripos($answer['question'], 'lastname') !== false
                || stripos($answer['question'], 'surname') !== false;
            if ($is_last_name) {
                $details['last_name'] = $answer['answer'];
            }
        }

        return $details;
    }

    private function getBookingDetails($booking)
    {
        return [
            'phone_number' => $booking->phone_number,
            'first_name' => $booking->first_name,
            'last_name' => $booking->last_name,
        ];
    }

    private function getReservationDetail($reservation)
    {

        $details = [];
        $name = explode(' ', $reservation->name);
        $details['phone_number'] = $reservation->contact_number;
        $details['first_name'] = array_shift($name);
        if (!empty($name)) {
            $details['last_name'] = implode(' ', $name);
        }

        return $details;
    }
}
