<?php

namespace App\Console\Commands;

use Carbon\Carbon;
use Illuminate\Console\Command;
use Mtc\MercuryDataModels\SalesChannelHistory;

class ClearSalesChannelHistory extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'clear:sales-channel-history';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Clear old sales channel history data';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        SalesChannelHistory::query()
            ->where('created_at', '<=', Carbon::now()->subDays(config('logging.sales-channel-history-age')))
            ->delete();

        return 0;
    }
}
