<?php

namespace App\Console\Commands;

use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class ClearOldFailedJobs extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'clear:failed-jobs';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Remove failed jobs entries older than 7 days';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        DB::table('failed_jobs')
            ->where('failed_at', '<', Carbon::now()->subWeek())
            ->delete();

        return Command::SUCCESS;
    }
}
