<?php

namespace App\Checklist;

use App\Contracts\GoLiveChecklist;
use Mtc\MercuryDataModels\Tenant;
use Mtc\VehicleValuation\Facades\Valuation;

class ValuationProviderOk extends GoLiveChecklist
{
    public function category(): string
    {
        return GoLiveChecklist::DEVELOPER;
    }

    public function isApplicable(Tenant $site): bool
    {
        return Valuation::hasEnabledDriver();
    }

    public function key(): string
    {
        return 'valuation_provider_ok';
    }

    public function handle(): bool
    {
        $vrm = array_rand(array_flip(config('app.checklist_vehicles')));
        try {
            $result = Valuation::getVehicleVariants($vrm, 50000);
            if (!empty($result)) {
                $variant_id = $result[0]['variant_id'];
            }
            $result = Valuation::testProvider($vrm, 50000, $variant_id ?? null)->toArray();
            if (empty($result['retail_price']) && empty($result['average_price'])) {
                $this->failure_reason = __('go-live.errors.valuation-not-retrieved');
                return false;
            }
            return true;
        } catch (\Exception $exception) {
            $this->failure_reason = $exception->getMessage();
            return false;
        }
    }
}
