<?php

namespace App\Checklist;

use App\Contracts\GoLiveChecklist;
use App\Facades\Settings;

class UserbackDisabled extends GoLiveChecklist
{
    public function category(): string
    {
        return GoLiveChecklist::CONFIGURATION;
    }

    public function key(): string
    {
        return 'userback_disabled';
    }

    public function handle(): bool
    {
        $value = Settings::get('tracking-userback-token');
        if (!empty($value)) {
            $this->failure_reason = __('go-live.errors.userback-token-still-active');
            return false;
        }
        return true;
    }
}
