<?php

namespace App\Checklist;

use App\Contracts\GoLiveChecklist;
use App\Facades\Settings;

class SiteFaviconCheck extends GoLiveChecklist
{
    public function category(): string
    {
        return GoLiveChecklist::CONFIGURATION;
    }

    public function key(): string
    {
        return 'site_favicon';
    }

    public function handle(): bool
    {
        $has_icon = !empty(Settings::get('site-favicon'));
        if (!$has_icon) {
            $this->failure_reason = __('go-live.errors.no-favicon');
        }
        return $has_icon;
    }
}
