<?php

namespace App\Checklist;

use App\Contracts\GoLiveChecklist;
use Illuminate\Support\Facades\App;
use Mtc\MercuryDataModels\Finance\FinanceServiceHelper;
use Mtc\MercuryDataModels\Services\FinanceService;
use Mtc\MercuryDataModels\Tenant;
use Mtc\MercuryDataModels\Vehicle;

class FinanceProviderFunctional extends GoLiveChecklist
{
    public function category(): string
    {
        return GoLiveChecklist::DEVELOPER;
    }

    public function isApplicable(Tenant $site): bool
    {
        return FinanceServiceHelper::hasEnabledProvider();
    }

    public function key(): string
    {
        return 'finance_provider_functional';
    }

    public function handle(): bool
    {
        /** @var FinanceService $service */
        $service = App::make(FinanceService::class);
        $vehicle = Vehicle::query()->active()->first();
        if (!$vehicle) {
            $this->failure_reason == __('go-live.errors.no-vehicle-for-finance-test');
        }
        $result = $service->get($vehicle);
        if (($result['status'] ?? false) === 'fail') {
            $this->failure_reason = $result['message'];
        }
        return ($result['status'] ?? false) !== 'fail';
    }
}
