<?php

namespace App\Checklist;

use App\Contracts\GoLiveChecklist;
use Illuminate\Support\Str;

class CheckPrimaryDomain extends GoLiveChecklist
{
    public function category(): string
    {
        return GoLiveChecklist::DOMAINS;
    }

    public function key(): string
    {
        return 'primary_domain';
    }

    public function handle(): bool
    {
        $domain = \tenant()->domains()
            ->where('primary', 1)
            ->first();

        if (!$domain) {
            $this->failure_reason = __('go-live.errors.no-primary-domain');
            return false;
        }

        if (Str::endsWith($domain->domain, ['getautonomy.co.uk', 'localhost'])) {
            $this->failure_reason = __('go-live.errors.primary-domain-points-to-temporary-domain', [
                'domain' => $domain->domain
            ]);
            return false;
        }

        return true;
    }
}
