<?php

namespace App\Actions\IntegrationVerification;

use App\Modules\Stock\Skoda;

class VerifySkoda
{
    public function __construct(private Skoda $provider)
    {
        //
    }

    public function verify()
    {
        if ($this->ableToRetrieveVehicles() === false) {
            return response([
                'message' => __('integrations.unable_to_connect', ['dealer' => 'Skoda']),
            ], 422);
        }

        return true;
    }

    private function ableToRetrieveVehicles(): bool
    {
        return $this->provider->fetchVehicles($this->provider->endpoint())->isNotEmpty();
    }
}
