<?php

namespace Mtc\AutoTraderStock\Console\Commands;

use Illuminate\Console\Command;
use Mtc\AutoTraderStock\AutoTraderFileEngine;
use Mtc\AutoTraderStock\Contracts\AutoTraderEngineContract;

class ImportStockCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'auto-trader:import {--last_updated}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Import AutoTrader Stock';

    /**
     * @var AutoTraderFileEngine
     */
    private $driver;

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct(AutoTraderEngineContract $driver)
    {
        $this->driver = $driver;
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return void
     */
    public function handle(): void
    {
        if (config('auto_trader_stock.enabled') !== true) {
            $this->error('Sync Disabled');
            return;
        }

        if ($this->option('last_updated') && $this->driver->isApiDriver() === false) {
            // Skip incremental update for file based system
            return;
        }
        $this->info('Processing Started');
        $this->driver->run($this->option('last_updated'));
        $this->info('Processing Finished');
    }
}
