<?php

namespace Mtc\AutoTraderStock;

use Illuminate\Support\Facades\Storage;
use Maatwebsite\Excel\Facades\Excel;
use Mtc\AutoTraderStock\Contracts\AutoTraderApiImportContract;
use Mtc\AutoTraderStock\Contracts\AutoTraderEngineContract;
use Mtc\AutoTraderStock\Contracts\AutoTraderImportContract;
use Mtc\AutoTraderStock\Imports\AutoTraderApiToShopItemImport;
use Mtc\AutoTraderStock\Contracts\AutoTraderServiceContract;

class AutoTraderApiEngine implements AutoTraderEngineContract
{
    /**
     * @var AutoTraderService
     */
    protected $service;

    /**
     * @var AutoTraderApiImportContract
     */
    protected $import;

    public function __construct(AutoTraderServiceContract $service, AutoTraderApiImportContract $import)
    {
        $this->service = $service;
        $this->import = $import;
    }

    public function run($quick_sync = false)
    {
        $vehicles = $this->service->fetchVehicles($quick_sync);

        if ($quick_sync === false) {
            $this->import->removeOld($vehicles);
        }

        $vehicles->each(function ($vehicle_data) {
            if ($this->import->exists($vehicle_data) === false) {
                if (!empty($vehicle_data['vehicle']['derivativeId'])) {
                    $vehicle_data['enriched_data'] = $this->service->fetchAdditional($vehicle_data);
                }
                $this->import->add($vehicle_data);
            }
            $this->import->update($vehicle_data);
        });
    }

    public function isApiDriver(): bool
    {
        return true;
    }
}
