<?php

use Mtc\AutoTraderStock\Imports\AutoTraderApiToShopItemImport;
use Mtc\AutoTraderStock\Imports\AutoTraderFileToShopItemImport;

return [
    'enabled' => env('AUTO_TRADER_SYNC_ENABLED', true),

    'import_file' => env('AUTO_TRADER_IMPORT_FILE_NAME', 'AT-MTC-Website-Export.csv'),
    'disk_name' => 'stock',

//    'driver' => \Mtc\AutoTraderStock\AutoTraderFileEngine::class,
    'driver' => \Mtc\AutoTraderStock\AutoTraderApiEngine::class,

    'file_import_map' => AutoTraderFileToShopItemImport::class,
    'api_import_map' => AutoTraderApiToShopItemImport::class,

    // when to run sync in H:i format
    'sync_schedule' => [
        '10:04',
        '17:04',
    ],

    // dealer location IDs for feed file
    'dealer_locations' => [
        //
    ],

    // api details
    'use_sandbox' => env('AUTO_TRADER_USE_SANDBOX', false),
    'api_key' => env('AUTO_TRADER_API_KEY'),
    'api_secret' => env('AUTO_TRADER_API_SECRET'),
    'merchant_id' => env('AUTO_TRADER_MERCHANT_ID'),

    'perform_last_updated_sync' => true,
];