# AutoTrader Stock File import driver

This package handles AutoTrader stock file and imports into the automotive sites.
System automatically imports vehicle information into the system

## Installation 

1. Install
```shell
composer require mtcmedia/auto-trader-stock
```

2. Set filesystem path in config/filesystems.php where file will be located.
Config is set to use `stock` file driver, but an alternate can be used by updating config value.
```php
'stock' => [
    'driver' => 'sftp',
    'host' => '46.101.7.62',
    'username' => env('STOCK_SFTP_USERNAME'),
    'password' => env('STOCK_SFTP_PASSWORD'),
],
```

Stock username/password can be found here: https://projects.mtcmedia.co.uk/staff/vcs/view/2520 

System will run cron twice a day (after 10am and after 5pm to refresh feed).
This schedule can be changed via config file

## Configuration

System allows setting:

* stock delivery type (currently only csv is implemented, but AT has an api)
* Map that translates file to DB records

## Testing and usage
You can run `php artisan auto-trader:import` to trigger sync manually.