# AutoTrader Stock File import driver

This package handles AutoTrader stock file and imports into the automotive sites.
System automatically imports vehicle information into the system

## Installation 

1. Install
```shell
composer require mtcmedia/auto-trader-stock
```

2. Set filesystem path in config/filesystems.php where file will be located.
Config is set to use `stock` file driver, but an alternate can be used by updating config value.
```php
'stock' => [
    'driver' => 'local',
    'visibility' => 'public',
    'root' => dirname(__DIR__, 2) . '/upload',
],
```

3. Set .env for import file name in the path
```dotenv
AUTO_TRADER_IMPORT_FILE_NAME=filename.csv
```

System will run cron twice a day (after 9am and after 5pm to refresh feed).

## Configuration

System allows setting:

* csv file name
* filesystem driver where stock file is located
* stock delivery type (currently only csv is implemented, but AT has an api)
* Map that translates file to DB records

## Testing and usage
You can run `php artisan auto-trader:import` to trigger sync manually.