<?php

namespace Mtc\Auction;

use Illuminate\Database\Eloquent\Model;

class PriceTrendEntry extends Model
{
    /**
     * Classes associated table
     *
     * @var string $table
     */
    protected $table = 'auction_lot_price_trend_entries';

    protected $fillable = [
        'price_trend_id',
        'data_source',
        'auction_date',
        'amount',
    ];

    /**
     * Relationship with PriceTrend
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function auction()
    {
        return $this->belongsTo(PriceTrend::class, '');
    }
}