<?php

namespace Mtc\Auction\Member;

use Mtc\Auction\Auction;
use Mtc\Auction\Bid;
//use Mtc\Modules\Auction\Classes\Http\Controllers\LotController;
use Mtc\Auction\Lot;
//use Mtc\Modules\Auction\Classes\MemberNotification;
use Illuminate\Support\Facades\Auth;
use Mtc\Members\Member;
use Mtc\Orders\Events\OrderPaid;
//use Mtc\Shop\Setting;

//use const Mtc\Modules\Auction\Classes\REGISTRATION_FEE_FOR_BIDDERS;
//use const Mtc\Modules\Auction\Classes\REGISTRATION_FEE_FOR_SELLERS;

/**
 * Trait InteractsWithAuctions
 * Adds Auction specific functionality to users
 *
 * @package Mtc\Modules\Auction\Classes
 */
trait InteractsWithAuctions
{
    /**
     * PLU that will be added for order item to recognize membership payment
     *
     * @var string $membership_fee_PLU
     */
    public static $membership_fee_PLU = 'MEMBERS_FEE';

    public static $payout_methods = [
        'bank_transfer' => 'Bank Transfer',
        //'paypal' => 'PayPal',
        //'transferwise' => 'TransferWise',
    ];

    /**
     * Member has ability to set the notification settings
     *
     * @return mixed
     */
    /*public function notificationSettings()
    {
        return $this->hasOne(MemberNotification::class, 'member_id');
    }*/

    /**
     * $member->can_bid
     *
     * @return bool
     */
    public function getCanBidAttribute()
    {
        if (!$this->allowed_to_bid) {
            return false;
        }/*

        if (REGISTRATION_FEE_FOR_BIDDERS !== true) {
            return true;
        }*/

        return $this->registration_fee_paid_at != null;
    }

    /**
     * Add ability to get a masked
     * @return string
     */
    public function getHashedIdAttribute()
    {
        return sha1($this->id);
    }

    /**
     * $member->can_sell
     *
     * @return bool
     */
    /*public function getCanSellAttribute()
    {
        if (REGISTRATION_FEE_FOR_SELLERS !== true) {
            return true;
        }

        return $this->registration_fee_paid_at != null;
    }*/

    /**
     * $member->should_pay_registration_fee
     *
     * @return bool
     */
    /*public function getShouldPayRegistrationFeeAttribute()
    {
        if (REGISTRATION_FEE_FOR_SELLERS !== true && REGISTRATION_FEE_FOR_BIDDERS !== true) {
            return true;
        }

        return $this->registration_fee_paid_at == null;
    }*/

    /**
     * Make sure auction membership payments are processed and user is updated
     *
     * @param OrderPaidEvent $event
     */
    /*public static function processOrderPaymentForAuction(OrderPaidEvent $event)
    {
        global $twig;

        $order = $event->getOrder();

        $order_items = collect($event->getOrder()->getItems());
        if ($order_items->where('PLU', InteractsWithAuctions::$membership_fee_PLU)->isEmpty()) {
            return;
        }

        $member_verification_required = Setting::where('name', 'enable_member_verification')->first()->value;

        Member::query()
            ->where('id', $event->getOrder()->member)
            ->update([
                // Disable new members from being able to bid when they first register (if shop setting is enabled).
                'allowed_to_bid' => $member_verification_required ? 0 : 1,
                'registration_fee_paid_at' => Carbon::now(),
            ]);

        // Disable new members from being able to bid when they first register (if shop setting is enabled).
        if ($member_verification_required) {
            $member = Member::find($event->getOrder()->member);

            $twig = App::make('twig');
            $content = $twig->render('Auction/emails/client_report_member_created.twig', [
                'member' => $member,
            ]);
            email(CONTACT_EMAIL, config('app.name') . ' - Member Created (NEEDS APPROVED)', $content);
        }

        $member = \Mtc\Modules\Members\Classes\Auth::user();
        $twig->addGlobal('member', $member);
    }*/

    /**
     * @param $basket_item
     * @return bool
     */
    /*protected static function checkIfBasketItemIsRegistrationFee($basket_item)
    {
        return InteractsWithAuctions::$membership_fee_PLU == $basket_item['PLU'];
    }*/

    /**
     * Make sure user cannot edit qty for Member Registration Fee
     *
     * @param $basket_item
     * @return array
     */
    /*public static function shouldLockBasketItemQuantityForAuction($basket_item)
    {
        if (self::checkIfBasketItemIsRegistrationFee($basket_item)) {
            return [
                [
                    'quantity_lock' => true
                ]
            ];
        }
        return [];
    }*/

    /**
     * Finds out if a user has placed any bids on a particular lot.
     *
     * @param int $lot_id
     *
     * @return bool
     */
    /*public function userHasBidsOnLot($lot_id)
    {
        return Bid::where('lot_id', $lot_id)
            ->where('member_id', $this->id)
            ->exists();
    }*/

    /**
     * Relationship with lots that have been won but aren't puchased
     * @return mixed
     */
    /*public function lotsToPurchase()
    {
        return $this->hasMany(Lot::class, 'buyer_id')
            ->where('status', Lot\Status::SOLD)
            ->whereNull('buy_order_id');
    }*/

    /**
     * Get the list of buyers
     * Probably needs a refactor to optimise this section
     *
     * @return mixed
     */
    public static function buyerList()
    {
        $list = self::query();

        return $list
            ->get()
            ->keyBy('id')
            ->map(function ($item) {
                return $item->name . ' (' . $item->email . ')';
            });
    }

    /**
     * Get the list of sellers
     * Probably needs a refactor to optimise this section
     *
     * @return mixed
     */
    public static function sellerList()
    {
        $list = self::query();

        return $list
            ->get()
            ->keyBy('id')
            ->map(function ($item) {
                return $item->name . ' (' . $item->email . ')';
            });
    }


    /**
     * Get the list of members.
     *
     * @return array
     */
    public static function idNameEmailList()
    {
        return self::query()->with('addressBilling')
            ->get()
            ->sortBy('fullname')
            ->keyBy('id')
            ->map(function ($member) {
                return $member->fullname . ' [ ' . $member->email . ' ]';
            });
    }

    public static function checkForOutstandingLots()
    {
        $member = Auth::user();
        if (!$member->exists) {
            return;
        }

        if ($member->lotsToPurchase()->count() && stripos(request()->getRequestUri(), 'checkout') === false) {
            app('twig')->addGlobal('global_error', __('auction::lots.member_has_outstanding_lots', ['lot_count' =>$member->lotsToPurchase()->count()]));

            if (!$member->should_pay_registration_fee) {
                LotController::addWonLotsToBasket();
            }
        }
    }

    /**
     * Auto-magically decode seller details to $member->seller_data
     *
     * @return array
     */
    public function getSellerDataAttribute()
    {
        return empty($this->seller_details) ? [] : json_decode(decrypt($this->seller_details), true);
    }

    /**
     * Apply seller/payout details to all lots for this seller that have not had a payout made yet.
     *
     * @return void
     */
    public function addSellerDetailsToLots()
    {
        Lot::where('seller_id', $this->id)
            ->whereNull('payout_made_at')
            ->update([
                'payout_details' => $this->seller_details,
            ]);
    }

    /**
     * Apply seller/payout details to this seller from lot.
     *
     * @param Lot $lot
     *
     * @return void
     */
    public function addSellerDetailsFromLot(Lot $lot)
    {
        $this->seller_details = $lot->payout_details;
        $this->save();
    }

    /**
     * Gets a sum of lots winning in current auction.
     *
     * @return int
     */
    public function getLotsWinningSum()
    {
        if (!$this->exists) {
            return 0;
        }

        if (is_null($auction = Auction::currentLiveAuction())) {
            return 0;
        }

        return Lot::query()
            ->withHighestBidder()
            ->withBidValue(false)
            ->where('auction_id', $auction->id)
            ->whereHas('bids', function ($bid_query) {
                return $bid_query->where('member_id', $this->id);
            })
            ->having('highest_bidder', $this->id)
            ->havingRaw('`bid_value` >= `auction_lots`.`reserve_price`')
            ->get()
            ->sum('bid_value');
    }

    /**
     * Gets a count of lots winning in current auction.
     *
     * @return int
     */
    public function getLotsWinningCount()
    {
        if (!$this->exists) {
            return 0;
        }

        if (is_null($auction = Auction::currentLiveAuction())) {
            return 0;
        }

        return Lot::query()
            ->withHighestBidder()
            ->withBidValue(false)
            ->where('auction_id', $auction->id)
            ->whereHas('bids', function ($bid_query) {
                return $bid_query->where('member_id', $this->id);
            })
            ->having('highest_bidder', $this->id)
            ->havingRaw('`bid_value` >= `auction_lots`.`reserve_price`')
            ->get()
            ->count();
    }

    /**
     * Gets a sum of lots selling in current auction.
     *
     * @return int
     */
    public function getLotsSellingSum()
    {
        if (!$this->exists) {
            return 0;
        }

        if (is_null($auction = Auction::currentLiveAuction())) {
            return 0;
        }

        return Lot::query()
            ->withBidValue(true)
            ->where('auction_id', $auction->id)
            ->where('seller_id', $this->id)
            ->whereHas('bids')
            ->havingRaw('`bid_value` >= `auction_lots`.`reserve_price`')
            ->get()
            ->sum('bid_value');
    }

    /**
     * Gets a count of lots selling in current auction.
     *
     * @return int
     */
    public function getLotsSellingCount()
    {
        if (!$this->exists) {
            return 0;
        }

        if (is_null($auction = Auction::currentLiveAuction())) {
            return 0;
        }

        return Lot::query()
            ->withBidValue(true)
            ->where('auction_id', $auction->id)
            ->where('seller_id', $this->id)
            ->whereHas('bids')
            ->havingRaw('`bid_value` >= `auction_lots`.`reserve_price`')
            ->get()
            ->count();
    }
}
