<?php

namespace Mtc\Auction\Lot;

use Illuminate\Database\Eloquent\Model;
use Mtc\Auction\CollectionPoint;
use Mtc\Auction\Lot;
use Mtc\Auction\PickupMethod;

class SellerDelivery extends Model
{
    protected $table = 'auction_lot_seller_deliveries';
    
    protected $fillable = [
        'pickup_method_id',
        'delivery_method_date',
        'courier_details',
        'collection_point_id',
    ];

    /**
     * Lot relationship
     *
     * @return \Illuminate\Database\Eloquent\Relations\belongsTo
     */
    public function lot(){
        return $this->belongsTo(Lot::class, 'lot_id');
    }

    /**
     * Pickup Method relationship
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function pickup_method(){
        return $this->hasOne(PickupMethod::class, 'pickup_method_id');
    }

    /**
     * Collection Point relationship
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function collection_point(){
        return $this->hasOne(CollectionPoint::class, 'collection_point_id');
    }
    
    
}