<?php

namespace Mtc\Auction\Lot;

use Illuminate\Database\Eloquent\Model;
class ComplementaryPriority extends Model
{
    /**
     * Classes associated table
     *
     * @var string $table
     */
    protected $table = 'auction_lot_complementary_priority';



    /**
     * Fields that can be auto-filled
     *
     * @var array $fillable
     */
    protected $fillable = [
        'field_id',
        'priority',
    ];

    /**
     * Relationship with custom field that has this value
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function field()
    {
        return $this->belongsTo(CustomField::class, 'field_id');
    }

    /**
     * Fetch the list of priority rules as a list of database fields
     *
     * @return \Illuminate\Database\Eloquent\Builder[]|\Illuminate\Database\Eloquent\Collection|\Illuminate\Support\Collection
     */
    public static function prioritiesAsDatabaseFieldList() {
        return self::query()
                   ->with('field')
                   ->orderBy('priority', 'asc')
                   ->get()
                   ->map(function ($rule) {
                       return $rule->field->database_field;
                   });
    }
}