<?php

namespace Mtc\Auction\Lot;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Mtc\Auction\Lot;

trait BelongsToLot
{
    /**
     * Scope - ofItem()
     *
     * @param Builder $query Query to extend
     * @param Lot $lot
     * @return Builder
     */
    public function scopeOfLot(Builder $query, $lot)
    {
        return $query->where("lot_id", id($lot));
    }
    
    /**
     * Define Eloquent relationship to Item class
     * @return BelongsTo
     */
    public function lot()
    {
        return $this->belongsTo(Lot::class, 'lot_id', 'id');
    }
}