<?php
namespace Mtc\Auction\Kernel;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use Mtc\Auction\Commands\EveryMinute;
use Mtc\Auction\Commands\Daily;

class AuctionKernel extends ConsoleKernel
{
    protected $commands = [

        EveryMinute::class,
        Daily::class,

    ];
    
    protected function schedule(Schedule $schedule){
        $schedule->command('auction:minutely')->everyMinute();
        $schedule->command('auction:hourly')->hourly();
    }
}