<?php

namespace Mtc\Auction\Http\Response;

use Carbon\Carbon;
use Illuminate\Support\Collection;
use Mtc\Auction\Lot;
use Mtc\Auction\Watchlist;
use Illuminate\Support\Facades\Auth;
use Mtc\Members\Facades\MemberAuth;
use Mtc\Auction\AuctionMember;

class MyBidList
{

    /**
     * list of lots
     *
     * @var Collection $lot_list
     */
    protected $lot_list;

    /**
     * LotList constructor.
     *
     * @param Collection $lot_list
     */
    public function __construct(Collection $lot_list)
    {
        $this->lot_list = $lot_list;
    }

    /**
     * Update collection to have all necessary data
     *
     * @param bool $owner_info whether to show sensitive information
     * @return Collection
     */
    public function handle($owner_info = false)
    {
        $member = class_exists(MemberAuth::class) ? MemberAuth::user() : new \stdClass;

        //Mutate Logged in Member to the AuctionMember Class
        if(!is_null($member)){
            $member = AuctionMember::mutateMemberObject($member);
        }

        return $this->lot_list
            ->each(function (Lot $lot) use ($owner_info, $member) {
                $lot->setHidden($lot->hidden_from_lot_lists);

                // TODO: Placeholder Image
                $lot->current_bid = $lot->latestBid->bid ?? $lot->starting_price;
                $lot->max_bid = $lot->myLatestBid($member->id)->max_bid ?: false;
                $lot->owner = $lot->latestBid->member->hashed_id;
                $lot->thumb_image = $lot->defaultImage ? $lot->defaultImage->imageUrl('thumbs') : Lot\Image::DEFAULT_IMAGE_PATH;
                $lot->hover_thumb_image = $lot->hoverImage ? $lot->hoverImage->imageUrl('thumbs') : '';
                $lot->has_reserve = !empty(floatval($lot->reserve_price));
                $lot->url = $lot->getUrlAttribute();
                $lot->lot_id = $lot->getLotIdAttribute();
                $lot->time_left = Carbon::now()->diffInSeconds($lot->ends_at, false);
                $lot->status_text = Lot\Status::$lot_statuses[$lot->status];
                $lot->can_bid = $lot->canUserBidOnThisLot($member);$lot->own_lot = $lot->seller_id === $member->id;
                $lot->is_watching = Watchlist::isUserWatching($lot->id, $member);
                $lot->is_biddable = $lot->isBiddable();
                $lot->is_before_live = in_array($lot->status, Lot\Status::$pre_auction_statuses);
                $lot->is_live = $lot->status == Lot\Status::LIVE;
                $lot->is_logged_in = !is_null(MemberAuth::user());
                $lot->user_has_bids = $member->userHasBidsOnLot($lot->id);
                $lot->next_bid_increment = $lot->next_bid_increment;
                $lot->bid_descriptor_value = $lot->bid_descriptor_value;
                $lot->bid_descriptor_text = $lot->bid_descriptor_text;
                if ($owner_info) {
                    $lot->makeVisible('reserve_price');
                }


                $lot->user_must_pay_buyers_membership = (config('auction.settings.registration_fee_for_bidders')
                                                         && (!is_null($member))
                                                         && $member->auction_fields->buyer_membership_fee_paid) ? true : false;

            });
    }
    
}