<?php

namespace Mtc\Auction\Http\Controllers\api;

use App\Http\Controllers\Controller;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Mtc\Auction\Auction;

class AuctionController extends Controller {


    public function getCountDown(Request $request): JsonResponse{

        //find auction that will be going live today

        $formatted_countdown = 0;
        $auction = Auction::query()
            ->whereDate('starts_at', Carbon::today())
            ->first();

        if ($auction != null) {

            $countdown = Carbon::createFromFormat('Y-m-d H:i:s', $auction->starts_at);
            $formatted_countdown =  $countdown->format('M j, Y H:i:s');

        }

        $data = [
            'countdown' => $formatted_countdown
        ];

        return response()->json($data,200);

    }


}